package org.openqa.selenium.devtools.v119.overlay;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain provides various functionality related to drawing atop the inspected page.
 */
@Beta()
public class Overlay {

    /**
     * Disables domain notifications.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Overlay.disable", Map.copyOf(params));
    }

    /**
     * Enables domain notifications.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Overlay.enable", Map.copyOf(params));
    }

    /**
     * For testing.
     */
    public static Command<java.util.Map<String, Object>> getHighlightObjectForTest(org.openqa.selenium.devtools.v119.dom.model.NodeId nodeId, java.util.Optional<java.lang.Boolean> includeDistance, java.util.Optional<java.lang.Boolean> includeStyle, java.util.Optional<org.openqa.selenium.devtools.v119.overlay.model.ColorFormat> colorFormat, java.util.Optional<java.lang.Boolean> showAccessibilityInfo) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        includeDistance.ifPresent(p -> params.put("includeDistance", p));
        includeStyle.ifPresent(p -> params.put("includeStyle", p));
        colorFormat.ifPresent(p -> params.put("colorFormat", p));
        showAccessibilityInfo.ifPresent(p -> params.put("showAccessibilityInfo", p));
        return new Command<>("Overlay.getHighlightObjectForTest", Map.copyOf(params), ConverterFunctions.map("highlight", java.util.Map.class));
    }

    /**
     * For Persistent Grid testing.
     */
    public static Command<java.util.Map<String, Object>> getGridHighlightObjectsForTest(java.util.List<org.openqa.selenium.devtools.v119.dom.model.NodeId> nodeIds) {
        java.util.Objects.requireNonNull(nodeIds, "nodeIds is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeIds", nodeIds);
        return new Command<>("Overlay.getGridHighlightObjectsForTest", Map.copyOf(params), ConverterFunctions.map("highlights", java.util.Map.class));
    }

    /**
     * For Source Order Viewer testing.
     */
    public static Command<java.util.Map<String, Object>> getSourceOrderHighlightObjectForTest(org.openqa.selenium.devtools.v119.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("Overlay.getSourceOrderHighlightObjectForTest", Map.copyOf(params), ConverterFunctions.map("highlight", java.util.Map.class));
    }

    /**
     * Hides any highlight.
     */
    public static Command<Void> hideHighlight() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Overlay.hideHighlight", Map.copyOf(params));
    }

    /**
     * Highlights owner element of the frame with given id.
     * Deprecated: Doesn't work reliablity and cannot be fixed due to process
     * separatation (the owner node might be in a different process). Determine
     * the owner node in the client and use highlightNode.
     */
    @Deprecated()
    public static Command<Void> highlightFrame(org.openqa.selenium.devtools.v119.page.model.FrameId frameId, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> contentColor, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> contentOutlineColor) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("frameId", frameId);
        contentColor.ifPresent(p -> params.put("contentColor", p));
        contentOutlineColor.ifPresent(p -> params.put("contentOutlineColor", p));
        return new Command<>("Overlay.highlightFrame", Map.copyOf(params));
    }

    /**
     * Highlights DOM node with given id or with the given JavaScript object wrapper. Either nodeId or
     * objectId must be specified.
     */
    public static Command<Void> highlightNode(org.openqa.selenium.devtools.v119.overlay.model.HighlightConfig highlightConfig, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v119.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.String> selector) {
        java.util.Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("highlightConfig", highlightConfig);
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        selector.ifPresent(p -> params.put("selector", p));
        return new Command<>("Overlay.highlightNode", Map.copyOf(params));
    }

    /**
     * Highlights given quad. Coordinates are absolute with respect to the main frame viewport.
     */
    public static Command<Void> highlightQuad(org.openqa.selenium.devtools.v119.dom.model.Quad quad, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> color, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> outlineColor) {
        java.util.Objects.requireNonNull(quad, "quad is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("quad", quad);
        color.ifPresent(p -> params.put("color", p));
        outlineColor.ifPresent(p -> params.put("outlineColor", p));
        return new Command<>("Overlay.highlightQuad", Map.copyOf(params));
    }

    /**
     * Highlights given rectangle. Coordinates are absolute with respect to the main frame viewport.
     */
    public static Command<Void> highlightRect(java.lang.Integer x, java.lang.Integer y, java.lang.Integer width, java.lang.Integer height, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> color, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.RGBA> outlineColor) {
        java.util.Objects.requireNonNull(x, "x is required");
        java.util.Objects.requireNonNull(y, "y is required");
        java.util.Objects.requireNonNull(width, "width is required");
        java.util.Objects.requireNonNull(height, "height is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("x", x);
        params.put("y", y);
        params.put("width", width);
        params.put("height", height);
        color.ifPresent(p -> params.put("color", p));
        outlineColor.ifPresent(p -> params.put("outlineColor", p));
        return new Command<>("Overlay.highlightRect", Map.copyOf(params));
    }

    /**
     * Highlights the source order of the children of the DOM node with given id or with the given
     * JavaScript object wrapper. Either nodeId or objectId must be specified.
     */
    public static Command<Void> highlightSourceOrder(org.openqa.selenium.devtools.v119.overlay.model.SourceOrderConfig sourceOrderConfig, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v119.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v119.runtime.model.RemoteObjectId> objectId) {
        java.util.Objects.requireNonNull(sourceOrderConfig, "sourceOrderConfig is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("sourceOrderConfig", sourceOrderConfig);
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<>("Overlay.highlightSourceOrder", Map.copyOf(params));
    }

    /**
     * Enters the 'inspect' mode. In this mode, elements that user is hovering over are highlighted.
     * Backend then generates 'inspectNodeRequested' event upon element selection.
     */
    public static Command<Void> setInspectMode(org.openqa.selenium.devtools.v119.overlay.model.InspectMode mode, java.util.Optional<org.openqa.selenium.devtools.v119.overlay.model.HighlightConfig> highlightConfig) {
        java.util.Objects.requireNonNull(mode, "mode is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("mode", mode);
        highlightConfig.ifPresent(p -> params.put("highlightConfig", p));
        return new Command<>("Overlay.setInspectMode", Map.copyOf(params));
    }

    /**
     * Highlights owner element of all frames detected to be ads.
     */
    public static Command<Void> setShowAdHighlights(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowAdHighlights", Map.copyOf(params));
    }

    public static Command<Void> setPausedInDebuggerMessage(java.util.Optional<java.lang.String> message) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        message.ifPresent(p -> params.put("message", p));
        return new Command<>("Overlay.setPausedInDebuggerMessage", Map.copyOf(params));
    }

    /**
     * Requests that backend shows debug borders on layers
     */
    public static Command<Void> setShowDebugBorders(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowDebugBorders", Map.copyOf(params));
    }

    /**
     * Requests that backend shows the FPS counter
     */
    public static Command<Void> setShowFPSCounter(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowFPSCounter", Map.copyOf(params));
    }

    /**
     * Highlight multiple elements with the CSS Grid overlay.
     */
    public static Command<Void> setShowGridOverlays(java.util.List<org.openqa.selenium.devtools.v119.overlay.model.GridNodeHighlightConfig> gridNodeHighlightConfigs) {
        java.util.Objects.requireNonNull(gridNodeHighlightConfigs, "gridNodeHighlightConfigs is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("gridNodeHighlightConfigs", gridNodeHighlightConfigs);
        return new Command<>("Overlay.setShowGridOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowFlexOverlays(java.util.List<org.openqa.selenium.devtools.v119.overlay.model.FlexNodeHighlightConfig> flexNodeHighlightConfigs) {
        java.util.Objects.requireNonNull(flexNodeHighlightConfigs, "flexNodeHighlightConfigs is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("flexNodeHighlightConfigs", flexNodeHighlightConfigs);
        return new Command<>("Overlay.setShowFlexOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowScrollSnapOverlays(java.util.List<org.openqa.selenium.devtools.v119.overlay.model.ScrollSnapHighlightConfig> scrollSnapHighlightConfigs) {
        java.util.Objects.requireNonNull(scrollSnapHighlightConfigs, "scrollSnapHighlightConfigs is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scrollSnapHighlightConfigs", scrollSnapHighlightConfigs);
        return new Command<>("Overlay.setShowScrollSnapOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowContainerQueryOverlays(java.util.List<org.openqa.selenium.devtools.v119.overlay.model.ContainerQueryHighlightConfig> containerQueryHighlightConfigs) {
        java.util.Objects.requireNonNull(containerQueryHighlightConfigs, "containerQueryHighlightConfigs is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("containerQueryHighlightConfigs", containerQueryHighlightConfigs);
        return new Command<>("Overlay.setShowContainerQueryOverlays", Map.copyOf(params));
    }

    /**
     * Requests that backend shows paint rectangles
     */
    public static Command<Void> setShowPaintRects(java.lang.Boolean result) {
        java.util.Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("result", result);
        return new Command<>("Overlay.setShowPaintRects", Map.copyOf(params));
    }

    /**
     * Requests that backend shows layout shift regions
     */
    public static Command<Void> setShowLayoutShiftRegions(java.lang.Boolean result) {
        java.util.Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("result", result);
        return new Command<>("Overlay.setShowLayoutShiftRegions", Map.copyOf(params));
    }

    /**
     * Requests that backend shows scroll bottleneck rects
     */
    public static Command<Void> setShowScrollBottleneckRects(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowScrollBottleneckRects", Map.copyOf(params));
    }

    /**
     * Deprecated, no longer has any effect.
     */
    @Deprecated()
    public static Command<Void> setShowHitTestBorders(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowHitTestBorders", Map.copyOf(params));
    }

    /**
     * Request that backend shows an overlay with web vital metrics.
     */
    public static Command<Void> setShowWebVitals(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowWebVitals", Map.copyOf(params));
    }

    /**
     * Paints viewport size upon main frame resize.
     */
    public static Command<Void> setShowViewportSizeOnResize(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("show", show);
        return new Command<>("Overlay.setShowViewportSizeOnResize", Map.copyOf(params));
    }

    /**
     * Add a dual screen device hinge
     */
    public static Command<Void> setShowHinge(java.util.Optional<org.openqa.selenium.devtools.v119.overlay.model.HingeConfig> hingeConfig) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        hingeConfig.ifPresent(p -> params.put("hingeConfig", p));
        return new Command<>("Overlay.setShowHinge", Map.copyOf(params));
    }

    /**
     * Show elements in isolation mode with overlays.
     */
    public static Command<Void> setShowIsolatedElements(java.util.List<org.openqa.selenium.devtools.v119.overlay.model.IsolatedElementHighlightConfig> isolatedElementHighlightConfigs) {
        java.util.Objects.requireNonNull(isolatedElementHighlightConfigs, "isolatedElementHighlightConfigs is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("isolatedElementHighlightConfigs", isolatedElementHighlightConfigs);
        return new Command<>("Overlay.setShowIsolatedElements", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v119.dom.model.BackendNodeId> inspectNodeRequested() {
        return new Event<>("Overlay.inspectNodeRequested", ConverterFunctions.map("backendNodeId", org.openqa.selenium.devtools.v119.dom.model.BackendNodeId.class));
    }

    public static Event<org.openqa.selenium.devtools.v119.dom.model.NodeId> nodeHighlightRequested() {
        return new Event<>("Overlay.nodeHighlightRequested", ConverterFunctions.map("nodeId", org.openqa.selenium.devtools.v119.dom.model.NodeId.class));
    }

    public static Event<org.openqa.selenium.devtools.v119.page.model.Viewport> screenshotRequested() {
        return new Event<>("Overlay.screenshotRequested", ConverterFunctions.map("viewport", org.openqa.selenium.devtools.v119.page.model.Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event<>("Overlay.inspectModeCanceled", ConverterFunctions.empty());
    }
}
