package org.openqa.selenium.devtools.v118.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AttributionReportingSourceRegistrationResult {

    SUCCESS("success"),
    INTERNALERROR("internalError"),
    INSUFFICIENTSOURCECAPACITY("insufficientSourceCapacity"),
    INSUFFICIENTUNIQUEDESTINATIONCAPACITY("insufficientUniqueDestinationCapacity"),
    EXCESSIVEREPORTINGORIGINS("excessiveReportingOrigins"),
    PROHIBITEDBYBROWSERPOLICY("prohibitedByBrowserPolicy"),
    SUCCESSNOISED("successNoised"),
    DESTINATIONREPORTINGLIMITREACHED("destinationReportingLimitReached"),
    DESTINATIONGLOBALLIMITREACHED("destinationGlobalLimitReached"),
    DESTINATIONBOTHLIMITSREACHED("destinationBothLimitsReached"),
    REPORTINGORIGINSPERSITELIMITREACHED("reportingOriginsPerSiteLimitReached"),
    EXCEEDSMAXCHANNELCAPACITY("exceedsMaxChannelCapacity");

    private String value;

    AttributionReportingSourceRegistrationResult(String value) {
        this.value = value;
    }

    public static AttributionReportingSourceRegistrationResult fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingSourceRegistrationResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingSourceRegistrationResult "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingSourceRegistrationResult fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
