/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.ModifierOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.Replacement;
import com.google.googlejavaformat.java.StringWrapper;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

@Immutable
public final class Formatter {
    public static final int MAX_LINE_LENGTH = 100;
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private final JavaFormatterOptions options;

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(final JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) throws FormatterException {
        JavaInputAstVisitor visitor;
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("allowStringFolding", "false");
        Options.instance(context).put("--enable-preview", "true");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput.getText();
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(javaInput.getText(), true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        javaInput.setCompilationUnit(unit);
        Iterable<Diagnostic<? extends JavaFileObject>> errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        if (Runtime.version().feature() >= 17) {
            try {
                visitor = Class.forName("com.google.googlejavaformat.java.java17.Java17InputAstVisitor").asSubclass(JavaInputAstVisitor.class).getConstructor(OpsBuilder.class, Integer.TYPE).newInstance(builder, options.indentationMultiplier());
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        } else {
            visitor = new JavaInputAstVisitor(builder, options.indentationMultiplier());
        }
        visitor.scan((Tree)unit, null);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps(builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), 100, new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    static boolean errorDiagnostic(Diagnostic<?> input) {
        if (input.getKind() != Diagnostic.Kind.ERROR) {
            return false;
        }
        switch (input.getCode()) {
            case "compiler.err.invalid.meth.decl.ret.type.req": {
                return false;
            }
        }
        return true;
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write(this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, ImmutableList.of(Range.closedOpen(0, input.length())));
    }

    public String formatSourceAndFixImports(String input) throws FormatterException {
        input = ImportOrderer.reorderImports(input, this.options.style());
        input = RemoveUnusedImports.removeUnusedImports(input);
        String formatted = this.formatSource(input);
        formatted = StringWrapper.wrap(formatted, this);
        return formatted;
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return JavaOutput.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput(input);
        if (this.options.reorderModifiers()) {
            javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        }
        String lineSeparator = Newlines.guessLineSeparator(input);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, javaInput, new JavaCommentsHelper(lineSeparator, this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException(e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        for (Range<Integer> lineRange : lineRanges.subRangeSet(Range.closedOpen(0, lines.size() - 1)).asRanges()) {
            int lineStart = (Integer)lines.get(lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get(lineRange.upperEndpoint()) - 1;
            Range<Integer> range = Range.closedOpen(lineStart, lineEnd);
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

